# Copyright (C) 2025 MicroSys Electronics GmbH
# Author: Kay Potthoff <kay.potthoff@microsys.de>

FILESEXTRAPATHS:prepend := "${THISDIR}/${PN}:${THISDIR}/u-boot-qoriq:"

SRC_URI = "${UBOOT_SRC};branch=${UBOOT_BRANCH}"

require u-boot-ms-common.inc

PROVIDES += "${MLPREFIX}u-boot-binman"
PROVIDES:class-native += "u-boot-binman-native"
PROVIDES += "nativesdk-u-boot-binman"
RPROVIDES:${PN} += "nativesdk-u-boot-binman"

PACKAGES += "${PN}-binman"

do_install:append() {

    install -d ${D}${datadir}
    install -d ${D}${datadir}/u-boot/tools
    install -d ${D}${datadir}/u-boot/scripts/dtc

    for mod in binman u_boot_pylib dtoc; do
      cp -a ${S}/tools/${mod} ${D}${datadir}/u-boot/tools
    done

    cp -a ${B}/scripts/dtc/pylibfdt ${D}${datadir}/u-boot/scripts/dtc
    rm -fr ${D}${datadir}/u-boot/scripts/dtc/pylibfdt/.debug

    chown -R root:root ${D}${datadir}
}

do_deploy:append() {

    install -d ${DEPLOYDIR}/secure-boot/${datadir}
    install -d ${DEPLOYDIR}/secure-boot/${datadir}/u-boot/tools
    install -d ${DEPLOYDIR}/secure-boot/${datadir}/u-boot/scripts/dtc

    for mod in binman u_boot_pylib dtoc; do
      cp -a ${S}/tools/${mod} ${DEPLOYDIR}/secure-boot/${datadir}/u-boot/tools
    done

    cp -a ${B}/scripts/dtc/pylibfdt ${DEPLOYDIR}/secure-boot/${datadir}/u-boot/scripts/dtc
    rm -fr ${D}${datadir}/u-boot/scripts/dtc/pylibfdt/.debug
}

FILES:${PN}-binman = "${datadir}/u-boot"

INSANE_SKIP += "dev-so file-rdeps arch"
INHIBIT_PACKAGE_STRIP = "1"
INHIBIT_SYSROOT_STRIP = "1"
INHIBIT_PACKAGE_DEBUG_SPLIT = "1"
ERROR_QA:remove = "patch-status"
